# 画面設計書 51-kubeadm kubeconfig

## 概要

本ドキュメントは、kubeadmツールの `kubeadm kubeconfig` コマンドに関する画面設計書である。kubeconfigファイルの生成ユーティリティとして、追加ユーザー向けのkubeconfigファイルを標準出力に出力する機能を提供する。

### 本画面の処理概要

`kubeadm kubeconfig` コマンドは、Kubernetesクラスターへの接続に使用するkubeconfigファイルの生成ユーティリティを提供するCLIコマンドである。現在はサブコマンドとして `user` のみを持ち、追加ユーザー向けのkubeconfigファイルを生成・出力する。

**業務上の目的・背景**：Kubernetesクラスターでは、各ユーザーやサービスアカウントがAPI Serverに接続するためにkubeconfigファイルが必要となる。`kubeadm init` で初期生成されるkubeconfigファイル以外に、追加のユーザー用kubeconfigを生成する必要がある場面がある。本コマンドは、クライアント証明書ベースまたはトークンベースの認証情報を含むkubeconfigファイルを標準出力に生成することで、運用管理者がクラスターへのアクセス設定を効率的に行えるようにする。

**画面へのアクセス方法**：ターミナル上で `kubeadm kubeconfig user --client-name=<名前>` コマンドを実行する。必要に応じて `--config` フラグでkubeadm設定ファイルを指定する。

**主要な操作・処理内容**：
1. `kubeadm kubeconfig user --client-name=foo` で追加ユーザー「foo」向けのkubeconfigを生成
2. `--token` フラグを指定した場合、トークンベースの認証情報を含むkubeconfigを出力
3. `--token` フラグを省略した場合、クライアント証明書ベースの認証情報を含むkubeconfigを出力
4. `--org` フラグで証明書のOrganization（グループ）を指定可能
5. `--validity-period` フラグで証明書の有効期間を指定可能
6. `--config` フラグでkubeadm設定ファイルを指定可能

**画面遷移**：本コマンドは `kubeadm` のサブコマンドとして位置し、他のkubeadmコマンドと並列に存在する。直接的な画面遷移はなく、生成したkubeconfigを使って `kubectl` など他のツールからクラスターにアクセスする。

**権限による表示制御**：本コマンドの実行にはCA証明書・秘密鍵へのアクセス権（通常はroot権限）が必要。トークンモード使用時はCA秘密鍵は不要だがCA証明書は必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | Config管理 | 主機能 | kubeconfigファイルの生成・管理を行う主処理 |
| 121 | 証明書管理 | 補助機能 | kubeconfig生成時にクライアント証明書情報を埋め込む |

## 画面種別

CLIコマンド（kubeconfigファイル生成ユーティリティ）

## URL/ルーティング

```
kubeadm kubeconfig user [flags]
```

## 入出力項目

| 項目名 | 入出力 | 必須 | 型 | デフォルト値 | 説明 |
|--------|--------|------|-----|-------------|------|
| --client-name | 入力 | 必須 | string | - | ユーザー名。クライアント証明書生成時にCN（Common Name）として使用される |
| --token | 入力 | 任意 | string | "" | クライアント証明書の代わりにトークンベース認証を使用する場合のトークン文字列 |
| --org | 入力 | 任意 | []string | [] | クライアント証明書のOrganization（O）フィールド。複数指定可能 |
| --validity-period | 入力 | 任意 | duration | 8760h0m0s (1年) | クライアント証明書の有効期間 |
| --config | 入力 | 任意 | string | "" | kubeadm設定ファイルのパス |
| kubeconfig YAML | 出力 | - | YAML | - | 生成されたkubeconfigファイルの内容（標準出力） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| kubeconfig YAML | クラスター情報、認証情報、コンテキスト情報を含むkubeconfig形式のYAMLデータ |

## イベント仕様

### 1-kubeadm kubeconfig user 実行

コマンド実行時の処理フローは以下の通り。

1. `--config` で指定された設定ファイル、またはデフォルトの `InitConfiguration` / `ClusterConfiguration` をロード（`configutil.LoadOrDefaultInitConfiguration`）
2. `--validity-period` の値がデフォルトの証明書有効期間より長い場合、警告メッセージを出力
3. 証明書の有効期間（`notAfter`）を現在時刻と `--validity-period` から計算
4. `--token` が指定されている場合:
   - `kubeconfigphase.WriteKubeConfigWithToken()` を呼び出し、トークンベースのkubeconfigを標準出力に出力
5. `--token` が指定されていない場合:
   - `kubeconfigphase.WriteKubeConfigWithClientCert()` を呼び出し、クライアント証明書ベースのkubeconfigを標準出力に出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはKubernetes API Serverやetcdに対するデータ操作を行わない。kubeconfigファイルの内容は標準出力に出力されるのみであり、ローカルファイルシステムやクラスター上のリソースは変更しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| kubeconfig user実行 | なし | なし | 標準出力へのkubeconfig出力のみ |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 警告 | `WARNING: the specified certificate validity period %v is longer than the default duration %v, this may increase security risks.` | `--validity-period` がデフォルト値（`CertificateValidityPeriod`）を超過した場合 |
| エラー | `couldn't create a kubeconfig; the CA files couldn't be loaded` | CA証明書・秘密鍵ファイルの読み込みに失敗した場合 |
| エラー | required flag(s) "client-name" not set | `--client-name` フラグが指定されていない場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| `--client-name` 未指定 | cobra フレームワークによるエラー出力。必須フラグの未指定として処理 |
| 設定ファイル読み込み失敗 | `LoadOrDefaultInitConfiguration` がエラーを返却し、コマンドが異常終了 |
| CA証明書・秘密鍵の読み込み失敗 | `TryLoadCertAndKeyFromDisk` がエラーを返却（クライアント証明書モード時） |
| CA証明書の読み込み失敗 | トークンモードでも CA証明書は必要。読み込み失敗時はエラー |
| 引数が指定された場合 | `cobra.NoArgs` 制約により、位置引数を受け取るとエラー |

## 備考

- 本コマンドは `kubeadm init` フェーズの一部としても利用されるkubeconfig生成ロジックを再利用している
- `--validity-period` はデフォルトで `CertificateValidityPeriod`（1年）に設定されている
- 生成されるkubeconfigにはクラスターのコントロールプレーンエンドポイントが含まれる
- クライアント証明書モードの場合、CA秘密鍵（`ca.key`）へのアクセスが必要
- CRI検出はスキップされる（`SkipCRIDetect: true`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

kubeconfig生成に使用される設定構造体と認証情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kubeconfig.go | `cmd/kubeadm/app/phases/kubeconfig/kubeconfig.go` | `kubeConfigSpec` 構造体（68-76行目）: kubeconfig生成に必要な情報（CA証明書、APIサーバーアドレス、クライアント名、認証情報）を保持 |
| 1-2 | kubeconfig.go | `cmd/kubeadm/app/phases/kubeconfig/kubeconfig.go` | `clientCertAuth` 構造体（57-60行目）と `tokenAuth` 構造体（63-65行目）: 2種類の認証方式を表現 |

**読解のコツ**: `kubeConfigSpec` が最終的にkubeconfig YAMLに変換される中間表現であることを意識する。

#### Step 2: エントリーポイントを理解する

コマンドの定義と実行フローの起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubeconfig.go | `cmd/kubeadm/app/cmd/kubeconfig.go` | `newCmdKubeConfigUtility()` 関数（56-65行目）: 親コマンド `kubeconfig` の定義。`user` サブコマンドを追加 |
| 2-2 | kubeconfig.go | `cmd/kubeadm/app/cmd/kubeconfig.go` | `newCmdUserKubeConfig()` 関数（68-129行目）: `user` サブコマンドの定義。フラグの定義とRunE関数の設定 |

**主要処理フロー**:
1. **87-92行目**: `configutil.LoadOrDefaultInitConfiguration` で設定をロード
2. **94-97行目**: 有効期間の警告チェック
3. **102-106行目**: 証明書の `notAfter` 時刻を計算
4. **109-111行目**: トークンモード時の `WriteKubeConfigWithToken` 呼び出し
5. **114行目**: 証明書モード時の `WriteKubeConfigWithClientCert` 呼び出し

#### Step 3: kubeconfig生成ロジックを理解する

実際のkubeconfig生成処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubeconfig.go | `cmd/kubeadm/app/phases/kubeconfig/kubeconfig.go` | `WriteKubeConfigWithClientCert()` 関数（324行目～）: クライアント証明書ベースのkubeconfig生成 |
| 3-2 | kubeconfig.go | `cmd/kubeadm/app/phases/kubeconfig/kubeconfig.go` | `WriteKubeConfigWithToken()` 関数（355行目～）: トークンベースのkubeconfig生成 |

**主要処理フロー**:
- **324-340行目**: CA証明書・鍵の読み込み、コントロールプレーンエンドポイントの取得、`kubeConfigSpec` の構築
- **355-375行目**: トークンモードでも同様にCA証明書を読み込み、`kubeConfigSpec` を構築

### プログラム呼び出し階層図

```
kubeadm kubeconfig user
    |
    +-- newCmdKubeConfigUtility() [cmd/kubeadm/app/cmd/kubeconfig.go:56]
    |       |
    |       +-- newCmdUserKubeConfig() [cmd/kubeadm/app/cmd/kubeconfig.go:68]
    |               |
    |               +-- configutil.LoadOrDefaultInitConfiguration() [設定ロード]
    |               |
    |               +-- (tokenモード) kubeconfigphase.WriteKubeConfigWithToken()
    |               |       |
    |               |       +-- pkiutil.TryLoadCertAndKeyFromDisk() [CA証明書読込]
    |               |       +-- kubeadmutil.GetControlPlaneEndpoint() [エンドポイント取得]
    |               |
    |               +-- (証明書モード) kubeconfigphase.WriteKubeConfigWithClientCert()
    |                       |
    |                       +-- pkiutil.TryLoadCertAndKeyFromDisk() [CA証明書・鍵読込]
    |                       +-- kubeadmutil.GetControlPlaneEndpoint() [エンドポイント取得]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

--client-name ────────+
--token ──────────────+
--org ────────────────+──> newCmdUserKubeConfig.RunE()
--validity-period ────+         |
--config ─────────────+         |
                                v
                    LoadOrDefaultInitConfiguration()
                                |
                                v
                    WriteKubeConfigWithToken() or
                    WriteKubeConfigWithClientCert()
                                |
                                v
                    kubeConfigSpec 構築 ───────> kubeconfig YAML ──> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kubeconfig.go | `cmd/kubeadm/app/cmd/kubeconfig.go` | ソース | コマンド定義・エントリーポイント |
| kubeconfig.go | `cmd/kubeadm/app/phases/kubeconfig/kubeconfig.go` | ソース | kubeconfig生成ロジック（WriteKubeConfigWithToken, WriteKubeConfigWithClientCert） |
| options.go | `cmd/kubeadm/app/cmd/options/` | ソース | 共通フラグ定義（AddConfigFlag等） |
| config.go | `cmd/kubeadm/app/util/config/` | ソース | 設定ファイルのロード処理 |
| constants.go | `cmd/kubeadm/app/constants/` | ソース | CertificateValidityPeriod等の定数定義 |
| pkiutil | `cmd/kubeadm/app/util/pkiutil/` | ソース | 証明書・鍵のファイル読み込み |
